implementation module EdMyIO;

/* OS dependent module for the powermacintosh */

import StdClass,StdFile, StdChar, StdInt, StdBool, StdString, StdMisc,StdArray;
import deltaFileSelect, deltaEventIO, deltaIOSystem, deltaSystem, deltaDialog;
import mac_types, OS_utilities;
from files import GetFInfo,GetCatInfo1,GetCatInfo2,HGetVol;

NoDate	:== {exists=False,yy=0,mm=0,dd=0,h=0,m=0,s=0};

::	DATE = {	exists	:: !Bool,
				yy		:: !Int,
				mm		:: !Int,
				dd		:: !Int,
				h		:: !Int,
				m		:: !Int,
				s		:: !Int };
				
FOpenDir :: !String !*Files -> (!Bool, !*Files);
FOpenDir name disk = (False, disk);

FCloseDir :: !*Files -> (Bool, !*Files);
FCloseDir disk = (False, disk);

FGetPlainFileName :: !*Files -> (!Bool, !String, !*Files);
FGetPlainFileName disk = (False, "", disk);

FExists	:: !String !*Files -> (!Bool, !*Files);
FExists name disk = (result == 0, disk);
	where {
	(result,_,_)	= GetFInfo name NewToolbox;
	};

FRemove	:: !String !*Files -> (!Bool, !*Files);
FRemove path disk
	= (True, disk);
	
FModified :: !String !*Files -> (!DATE, !*Files);
FModified path disk
	| result <> 0	= (NoDate,disk);
					= ({exists=True,yy=years,mm=months,dd=days,h=hours,m=minutes,s=seconds},disk);
	where {
	(result,modification,_)		= GetFInfo path NewToolbox;
	(years,months,days,_,_)		= Secs2Date modification 0;
	(hours,minutes,seconds,_)	= Secs2Time  modification 0;
	};
	
FStartUpDir :: !String !*Files -> (!String, !*Files);
FStartUpDir applicationname files
	| result==0
		= (pathName % (0,size pathName-2), files);
	where {

	(result,wd_vref_num,directory_id,tb1)	= HGetVol NewToolbox;
	(pathName,_)	= Get_directory_path wd_vref_num directory_id "" tb1;
	};

Get_name_and_parent_id_of_directory :: !Int !Int !*Toolbox -> (!String,!Int,!*Toolbox);
Get_name_and_parent_id_of_directory volumeNumber directoryId tb
	|	0 == osError	= (folderName,parentId,tb1);
						= abort ("Error code returned by BPGetCatInfo: " +++ toString osError);
	where {
	(osError,folderName,parentId,tb1) = GetCatInfo2 volumeNumber directoryId String64 tb;
	};

Get_directory_path :: !Int !Int !String !*Toolbox -> (!String, !*Toolbox);
Get_directory_path volumeNumber directoryId path tb
	| directoryId==2
		= (folderName +++ ":" +++ path, tb1);
		= Get_directory_path volumeNumber parentId (folderName +++ ":" +++ path) tb1;
	where {
		(folderName, parentId, tb1) = Get_name_and_parent_id_of_directory volumeNumber directoryId tb;
	};
	
String64 :: String;
String64	= createArray 64 '@';

Older_Date	:: !DATE !DATE -> Bool;
Older_Date	{exists=b1,yy=yy1,mm=mm1,dd=dd1,h=h1,m=m1,s=s1}
			{exists=b2,yy=yy2,mm=mm2,dd=dd2,h=h2,m=m2,s=s2}
	| b1		&& not b2	= True;
	| not b1	|| not b2	= False;
							= Older_IntList [yy1,mm1,dd1,h1,m1,s1] [yy2,mm2,dd2,h2,m2,s2];
	
Older_IntList	:: ![Int] ![Int] -> Bool;
Older_IntList []		[]					=  False;
Older_IntList [h1:t1]	[h2:t2]	| h1 < h2	=  True;
								| h1 > h2	=  False;
											=  Older_IntList t1 t2;
											
FTempFileName :: !String !*Files -> (!String, !*Files);
FTempFileName dir disk
	= (dir +++ ":temp", disk);

SelectDir :: !*state !(IOState *state) -> (!Bool, !String, !*state, !IOState *state);
SelectDir state io
	=  (open, RemoveFileName dirname`, state`, io`);
	where {
	(open, dirname`, state`, io`)= SelectInputFile state io;
	};
		
RemoveFileName :: !String -> String;
RemoveFileName path
		| found	= path % (0, dec position);
				= path;
		where {
		(found,position)	= LastColon path last;
		last				= dec (size path);
		};

LastColon :: !String !Int -> (!Bool, !Int);
LastColon s i
	| i <= 0
		= (False,0);
	| DirSeparator==s.[i]
	 	= (True, i);
		= LastColon s (dec i);
		
Launch ::	!String *state !(IOState *state)
			-> (!Bool,!Int,!*state,!IOState *state);
Launch progname state io
	=  (True, 0, state`, io`);
	where {
	(_, state`,io`)	= OpenNotice notice state io;
	notice		= Notice [("Execute \'" +++ progname) +++ "\'"] (NoticeButton 1 "OK") [];
	};

GetFullApplicationPath :: !*Files -> ({#Char}, *Files);
GetFullApplicationPath files
	=	FStartUpDir "" files;
